/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import IronSource

fileprivate let AD_UNIT_ID = "ydlnsf65myak6ryz"

final class IronSourceBannerAdViewController: BannerBaseViewController {
    
    private var isAdView: LPMBannerAdView?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        createAd()
    }
    
    deinit {
        isAdView?.destroy()
        isAdView = nil
    }
    
    private func createAd() {
        let adConfig = LPMBannerAdViewConfigBuilder()
            .set(adSize: .customSize(withWidth: Int(adSize.width), height: Int(adSize.height)))
            .build()
        
        let isAdView = LPMBannerAdView(adUnitId: AD_UNIT_ID, config: adConfig)
        isAdView.frame = CGRect(origin: .zero, size: adSize)
        isAdView.setDelegate(self)
        
        self.isAdView = isAdView
        
        containerView.addSubview(isAdView)
        
        isAdView.loadAd(with: self)
    }
    
    // MARK: Utils
    
    override func reload() {
        super.reload()
        
        isAdView?.removeFromSuperview()
        isAdView = nil
        
        createAd()
    }
}

// MARK: - LPMBannerAdViewDelegate
extension IronSourceBannerAdViewController: LPMBannerAdViewDelegate {
    
    func didLoadAd(with adInfo: LPMAdInfo) {
        reloadButton.isEnabled = true
    }
    
    func didFailToLoadAd(withAdUnitId adUnitId: String, error: any Error) {
        reloadButton.isEnabled = true
        print("ironSource did fail to load ad with error: \(error.localizedDescription)")
    }
    
    func didFailToDisplayAd(with adInfo: LPMAdInfo, error: any Error) {
        reloadButton.isEnabled = true
        print("ironSource did fail to display ad with error: \(error.localizedDescription)")
    }
    
    func didDisplayAd(with adInfo: LPMAdInfo) {}
    func didClickAd(with adInfo: LPMAdInfo) {}
    func didExpandAd(with adInfo: LPMAdInfo) {}
    func didCollapseAd(with adInfo: LPMAdInfo) {}
    func didLeaveApp(with adInfo: LPMAdInfo) {}
}
