/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import IronSource

fileprivate let AD_UNIT_ID = "lsppopbi0w1vk82q"

final class IronSourceMultiformatRewardedController: InterstitialBaseViewController {
    
    private var isRewardedAd: LPMRewardedAd?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        createAd()
    }
    
    private func createAd() {
        isRewardedAd = LPMRewardedAd(adUnitId: AD_UNIT_ID)
        isRewardedAd?.setDelegate(self)
        isRewardedAd?.loadAd()
    }
    
    override func showAd(_ sender: UIButton) {
        super.showAd(sender)
        
        if isRewardedAd?.isAdReady() == true {
            isRewardedAd?.showAd(
                viewController: self,
                placementName: nil
            )
        }
    }
    
    // MARK: Utils
    
    override func reload() {
        super.reload()
        
        isRewardedAd = nil
        
        createAd()
    }
}

// MARK: - LPMRewardedAdDelegate
extension IronSourceMultiformatRewardedController: LPMRewardedAdDelegate {
    
    func didLoadAd(with adInfo: LPMAdInfo) {
        showButton.isEnabled = true
        reloadButton.isEnabled = true
    }
    
    func didFailToLoadAd(withAdUnitId adUnitId: String, error: any Error) {
        reloadButton.isEnabled = true
        
        let nsError = error as NSError
        print("ironSource did fail to load ad with error: \(nsError.localizedDescription)")
    }
    
    func didFailToDisplayAd(with adInfo: LPMAdInfo, error: any Error) {
        reloadButton.isEnabled = true
        
        let nsError = error as NSError
        print("ironSource did fail to display ad with error: \(nsError.localizedDescription)")
    }
    
    func didRewardAd(with adInfo: LPMAdInfo, reward: LPMReward) {
        print("User did get reward.")
    }
    
    func didDisplayAd(with adInfo: LPMAdInfo) {}
    func didClickAd(with adInfo: LPMAdInfo) {}
    func didCloseAd(with adInfo: LPMAdInfo) {}
    func didChangeAdInfo(_ adInfo: LPMAdInfo) {}
}
