/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import UIKit

struct TestCase {
    let title: String
    let adFormats: Set<AdFormat>
    let integrationKind: IntegrationKind
    let configurationClosure: () -> UIViewController
}

struct TestCasesManager {
    
    static let allCases: [TestCase] = [
        
        TestCase(
            title: "Banner Ad View 300x250 [Boldwin]",
            adFormats: [.banner],
            integrationKind: .sdk,
            configurationClosure: {
                BoldwinBannerAdViewController()
            }
        ),
        
        TestCase(
            title: "Multiformat Interstitial [Boldwin]",
            adFormats: [.banner, .video],
            integrationKind: .sdk,
            configurationClosure: {
                BoldwinMultiformatInterstitialController()
            }
        ),
        
        TestCase(
            title: "Multiformat Rewarded [Boldwin]",
            adFormats: [.banner, .video],
            integrationKind: .sdk,
            configurationClosure: {
                BoldwinMultiformatRewardedController()
            }
        ),
        
        TestCase(
            title: "Banner Ad View 300x250 [AppLovin MAX]",
            adFormats: [.banner],
            integrationKind: .max,
            configurationClosure: {
                AppLovinBannerAdViewController()
            }
        ),
        
        TestCase(
            title: "Multiformat Interstitial [AppLovin MAX]",
            adFormats: [.banner, .video],
            integrationKind: .max,
            configurationClosure: {
                AppLovinMultiformatInterstitialController()
            }
        ),
        
        TestCase(
            title: "Multiformat Rewarded [AppLovin MAX]",
            adFormats: [.banner, .video],
            integrationKind: .max,
            configurationClosure: {
                AppLovinMultiformatRewardedViewController()
            }
        ),
        
        TestCase(
            title: "Banner Ad View 300x250 [ironSource]",
            adFormats: [.banner],
            integrationKind: .ironsource,
            configurationClosure: {
                IronSourceBannerAdViewController()
            }
        ),
        
        TestCase(
            title: "Multiformat Interstitial [ironSource]",
            adFormats: [.banner, .video],
            integrationKind: .ironsource,
            configurationClosure: {
                IronSourceMultiformatInterstitialController()
            }
        ),
        
        TestCase(
            title: "Multiformat Rewarded [ironSource]",
            adFormats: [.banner, .video],
            integrationKind: .ironsource,
            configurationClosure: {
                IronSourceMultiformatRewardedController()
            }
        ),
    ]
}
